#ifndef	_ASM_MN10300_SET_H
#define	_ASM_MN10300_SET_H

#ifndef __ASSEMBLY__
#include <linux/types.h>
#include <linux/ioctl.h>
#include <linux/wait.h>
#endif

#define SIGDTV				40

#ifdef __KERNEL__

#ifndef __ASSEMBLY__

#define ALLOC_CTLPACKET \
static CTLPACKET_TYPE * alloc_ctlpacket (void) \
{ \
  CTLPACKET_TYPE *packet; \
  if (list_empty (&CTLPACKET_HEAD)) { \
    packet = 0; \
    goto EXIT; \
  } \
  packet = (CTLPACKET_TYPE *)(CTLPACKET_HEAD.next); \
  list_del ((struct list_head *)packet); \
 EXIT: \
  return packet; \
}

#define FREE_CTLPACKET \
static void free_ctlpacket (CTLPACKET_TYPE * packet) \
{ \
  list_add ((struct list_head *)packet, &CTLPACKET_HEAD); \
}

#define PUT_CTLPACKET \
static int put_ctlpacket (unsigned int cmd, RIOCTL_TYPE *data, RDEV_TYPE *dev, int mode) \
{ \
  CTLPACKET_TYPE *packet; \
  int ret = 0; \
  spin_lock(&CTLPACKET_LOCK); \
  packet = alloc_ctlpacket (); \
  spin_unlock(&CTLPACKET_LOCK); \
  packet->cmd = cmd; \
  packet->minor = dev->minor; \
  if (mode) \
    ret = copy_from_user (&packet->ioctl, data, sizeof(RIOCTL_TYPE)); \
  else \
    memcpy (&packet->ioctl, data, sizeof(RIOCTL_TYPE)); \
  spin_lock(&CTLPACKET_LOCK); \
  list_add_tail((struct list_head *)packet, &RDEV_ARRAY[0].ctlpacket); \
  spin_unlock(&CTLPACKET_LOCK); \
  wake_up_interruptible (&RDEV_ARRAY[0].read_wait); \
  return ret; \
}

#define GET_CTLPACKET \
static int get_ctlpacket (CTLPACKET_TYPE *packet, RDEV_TYPE *dev, int mode) \
{ \
  struct list_head *list; \
  int ret = 0; \
  spin_lock(&CTLPACKET_LOCK); \
  if (!list_empty(&dev->ctlpacket)) { \
    list = dev->ctlpacket.next; \
    list_del(list); \
    spin_unlock(&CTLPACKET_LOCK); \
    if (mode&1) \
      if (mode&2) \
	ret = copy_to_user(packet, &((CTLPACKET_TYPE *)list)->ioctl, mode>>16); \
      else \
	ret = copy_to_user(packet, list, sizeof(CTLPACKET_TYPE)); \
    else \
      if (mode&2) \
	memcpy (&packet->ioctl, &((CTLPACKET_TYPE *)list)->ioctl, sizeof(RIOCTL_TYPE)); \
      else \
	memcpy (packet, list, sizeof(CTLPACKET_TYPE)); \
    spin_lock(&CTLPACKET_LOCK); \
    free_ctlpacket ((CTLPACKET_TYPE *)list); \
    spin_unlock(&CTLPACKET_LOCK); \
    return 1; \
  } \
  spin_unlock(&CTLPACKET_LOCK); \
  return -1; \
}

#define CHK_CTLPACKET \
static int chk_ctlpacket (RDEV_TYPE *dev) \
{ \
  int ret = 0; \
  spin_lock(&CTLPACKET_LOCK); \
  if (!list_empty(&dev->ctlpacket) && ((CTLPACKET_TYPE *)dev->ctlpacket.next)->minor > 0) { \
    ret = 1; \
  } \
  spin_unlock(&CTLPACKET_LOCK); \
  return ret; \
}

#define WAIT_ACK \
static void wait_ack(RDEV_TYPE *dev, CTLPACKET_TYPE *packet, int mode) \
{ \
  DECLARE_WAITQUEUE (wait, current); \
  add_wait_queue (&dev->ack_wait, &wait); \
  for (;;) { \
    set_current_state (TASK_INTERRUPTIBLE); \
    if (get_ctlpacket (packet, dev, mode) >= 0) \
      break; \
    clear_tsk_thread_flag (current, TIF_SIGPENDING); \
    schedule (); \
  } \
  recalc_sigpending(); \
  remove_wait_queue (&dev->ack_wait, &wait); \
  set_current_state (TASK_RUNNING); \
}

#define MAKE_SIGNAL \
static int make_signal(DEV_TYPE *dev, int signal) \
{ \
  CTLPACKET_TYPE *ctlpacket; \
  if (dev->sigcount >= SIGQUEPERDEV) \
    return -1; \
  ctlpacket = alloc_ctlpacket(); \
  if (!ctlpacket) \
    return -1; \
  ctlpacket->ioctl.ioctl.signal.signal = signal; \
  dev->sigcount ++; \
  list_add_tail((struct list_head *)ctlpacket, &dev->ctlpacket); \
  return 0; \
}

#define GET_SIGNAL \
static int get_signal(DEV_TYPE *dev, IOCTL_TYPE *arg) \
{ \
  DECLARE_WAITQUEUE (wait, current); \
  struct list_head *list; \
  int ret = 0; \
  add_wait_queue(&dev->read_wait, &wait); \
  while(1){ \
    set_current_state(TASK_INTERRUPTIBLE); \
    spin_lock(&CTLPACKET_LOCK); \
    if (!list_empty(&dev->ctlpacket)) \
      break; \
    spin_unlock(&CTLPACKET_LOCK); \
    if (signal_pending(current)) { \
      ret = -ERESTARTSYS; \
      break; \
    } \
    schedule(); \
  } \
  set_current_state(TASK_RUNNING); \
  remove_wait_queue(&dev->read_wait, &wait); \
  if (!ret) { \
    list = dev->ctlpacket.next; \
    list_del(list); \
    dev->sigcount --; \
    spin_unlock(&CTLPACKET_LOCK); \
    ret = copy_to_user(&arg->ioctl.signal, &((CTLPACKET_TYPE *)list)->ioctl.ioctl.signal, sizeof(arg->ioctl.signal)); \
    spin_lock(&CTLPACKET_LOCK); \
    free_ctlpacket ((CTLPACKET_TYPE *)list); \
    spin_unlock(&CTLPACKET_LOCK); \
  } \
  return ret; \
}

#define CANCEL_SIGNAL \
static void cancel_signal(DEV_TYPE *dev) \
{ \
  CTLPACKET_TYPE *packet; \
  while (!list_empty(&dev->ctlpacket)) { \
    packet = (CTLPACKET_TYPE *)(dev->ctlpacket.next); \
    list_del((struct list_head *)packet); \
    free_ctlpacket(packet); \
  } \
  dev->sigcount = 0; \
  recalc_sigpending(); \
}

#define SEND_EVENT \
static int send_event(DEV_TYPE *dev, IOCTL_TYPE *arg) \
{ \
  CTLPACKET_TYPE *ctlpacket; \
  int ret = 0; \
  if (dev->sigcount < SIGQUEPERDEV) { \
    ctlpacket = alloc_ctlpacket(); \
    if (!ctlpacket) \
      return -1; \
    ret = copy_from_user (&ctlpacket->cmd, arg, sizeof(CTLPACKET_TYPE)-sizeof(struct list_head)); \
    list_add_tail((struct list_head *)ctlpacket, &dev->ctlpacket); \
    wake_up_interruptible (&dev->read_wait); \
    if (dev->async_queue) \
      kill_fasync(&dev->async_queue, SIGDTV, POLL_IN); \
    dev->sigcount ++; \
  } \
  else { \
    return -1; \
  } \
  return 0; \
}

#define CTLPACKET_FUNC_SIG() ALLOC_CTLPACKET FREE_CTLPACKET PUT_CTLPACKET GET_CTLPACKET CHK_CTLPACKET WAIT_ACK MAKE_SIGNAL GET_SIGNAL CANCEL_SIGNAL SEND_EVENT
#define CTLPACKET_FUNC() ALLOC_CTLPACKET FREE_CTLPACKET PUT_CTLPACKET GET_CTLPACKET CHK_CTLPACKET WAIT_ACK

#endif /* __ASSEMBLY__ */

#endif /* __KERNEL */

#endif /* _ASM_MN10300_SET_H */
